<?php


class VideoComment extends AppModel
{

    public $useTable = 'video_comment';

    public $belongsTo = array(
        'Video' => array(
            'className' => 'Video',
            'foreignKey' => 'video_id',



        ),

        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',
            'fields' => USER_FIELDS
        ),

        'Parent' => array(
            'className' => 'VideoComment',
            'foreignKey' => 'parent_id',

        ),



    );

    public $hasMany = array(


        'Children' => array(
            'className' => 'VideoComment',
            'foreignKey' => 'parent_id',



        ),
    );

    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'VideoComment.id'=> $id,




            )
        ));
    }

    public function countComments($video_id)
    {
        return $this->find('count', array(
            'conditions' => array(



                'VideoComment.video_id'=> $video_id,




            )
        ));
    }

    public function getPinnedComment($video_id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'VideoComment.pin'=> 1,




            )
        ));
    }
    public function countCommentsBetweenDates($video_ids,$start_datetime,$end_datetime)
    {
        return $this->find('count', array(
            'conditions' => array(



                'VideoComment.video_id IN'=> $video_ids,
                'DATE(VideoComment.created) >='=> $start_datetime,
                'DATE(VideoComment.created) <='=> $end_datetime,




            )
        ));
    }



    public function getVideoComments($video_id, $starting_point)
    {
        // Fetch the parent comments first (parent_id = 0)
        $parentComments = $this->find('all', array(
            'conditions' => array(
                'VideoComment.video_id' => $video_id,
                'VideoComment.parent_id' => 0,
            ),
            'limit' => 20,
            'offset' => $starting_point * 20,
            'order' => 'VideoComment.id DESC',
            'contain' => array(
                'User', // Include the User association
                'Children' => array(
                    'User' // Include User for Children, but exclude Video
                )
            )
        ));

        // Remove the Video association from the result manually
        foreach ($parentComments as $key => $comment) {
            unset($parentComments[$key]['Video']); // Unset the Video object from the parent comment
            $parentComments[$key]['Children'] = $this->getNestedComments($comment['VideoComment']['id']);
        }

        return $parentComments;
    }

    /**
     * Recursive function to fetch nested comments (children and their children).
     *
     * @param int $parent_id - The parent comment ID.
     * @return array - Nested children comments.
     */
    public function getNestedComments($parent_id)
    {
        $children = $this->find('all', array(
            'conditions' => array(
                'VideoComment.parent_id' => $parent_id
            ),
            'order' => 'VideoComment.id ASC', // You can change order if needed
            'contain' => array(
                'User', // Include User, but exclude Video
                'Children' => array(
                    'User' // Nested Children with User
                )
            )
        ));

        // For each child, recursively find their children and unset the Video association
        foreach ($children as $key => $child) {
            unset($children[$key]['Video']); // Unset the Video object from each child comment
            $children[$key]['Children'] = $this->getNestedComments($child['VideoComment']['id']);
        }

        return $children;
    }
    public function getAll()
    {
        return $this->find('all');
    }

    public function updatePin($video_id){

        $this->updateAll(
            array('VideoComment.pin' => 0),
            array('VideoComment.video_id' => $video_id)
        );

    }





}
?>